#! /bin/bash 
# The script for writing the CMPA page into LPC55Sxx

# Input file: ${SPT_WORKSPACE}/configs/cmpa.json

# Environment variables - absolute paths simplifying re-use of the script on another machine
#  - Absolute path to SPT workspace (it is recommended to copy/move all user files in this workspace)
if [ -z "${SPT_WORKSPACE}" ]; then
  export "SPT_WORKSPACE=$(cd "$(dirname "$0")"; pwd -P)"
  export "SPT_WORKSPACE=$(dirname "$SPT_WORKSPACE")"
fi
if ! [ -d "$SPT_WORKSPACE" ]; then
  echo "FAILURE: Directory not found: $SPT_WORKSPACE"
  exit 2
fi
#  - Absolute path to SPT installation directory
if [ -z "${SPT_INSTALL_BIN}" ]; then
  export "SPT_INSTALL_BIN=C:/nxp/MCUX_Provi_v8/bin"
fi
if ! [ -d "$SPT_INSTALL_BIN" ]; then
  echo "FAILURE: Directory not found: $SPT_INSTALL_BIN"
  exit 2
fi


# Default connection parameters
export "blhost_connect=-p COM7,115200"

# Used command line utilities
export "blhost=${SPT_INSTALL_BIN}/tools_scripts/blhost_spsdk_lnx_wrapper.sh"
export "pfr=${SPT_INSTALL_BIN}/tools/spsdk/pfr"

echo "### Create CMPA page (binary) ###"
pushd "$SPT_WORKSPACE"
echo "%pfr% generate-binary -c ${SPT_WORKSPACE}/configs/cmpa.json -o ${SPT_WORKSPACE}/configs/cmpa.bin"
"$pfr" generate-binary -c "${SPT_WORKSPACE}/configs/cmpa.json" \
        -o "${SPT_WORKSPACE}/configs/cmpa.bin"
if [ $? -ge 1 ]; then
    popd
    exit 2
fi
popd

# Ping the device to establish communication; Result is ignored as the communication sometime fails for the first time
"$blhost" $blhost_connect -j -- get-property 1 0 > nul

# ### Check connection ###
"$blhost" $blhost_connect -j -- get-property 1 0
if [ $? -ge 2 ]; then
    exit 2
fi

echo "### Write Customer Manufacturing/Factory Programmable Area [CMPA] ###"
"$blhost" $blhost_connect -j -- write-memory 0x0003E200 "${SPT_WORKSPACE}/configs/cmpa.bin"
if [ $? -ge 2 ]; then
    exit 2
fi